# White Cloud Farm (Babylon)

## Introduction

<img src="illustrations/Logo-60.png" width="60" height="60" align="left"/><p style="display:inline-block; vertical-align:middle;">The White Cloud Farm sky cultures are a set of colored versions of the modern sky culture with specified modifications. It was developed for use in biblical studies, especially of the book of Revelation, based on White Cloud Farm publications.</p>

<hr>

## Description

Using Stellarium for Bible study might seem unusual at first, but the application becomes clear when one considers that the Bible teaches there is one Creator who made both the heavens and the earth. Jesus instructed His disciples to look up when certain events would begin to unfold (Luke 21:28), which suggests observing heavenly signs. These signs are said to be revealed through the celestial luminaries—the sun, moon, and stars (whether moving or fixed)—which also delineate time.

> *And God said, Let there be lights in the firmament of the heaven to divide the day from the night; and **let them be for signs,** and for seasons, and for days, and years: (Genesis 1:14)*

To better understand the timing of end-time events, some have started “looking up” and watching the heavens in light of biblical prophecies. While many Christians shy away from such studies, others pursue them despite the challenges, as Jesus consistently paired the acknowledgment that we do not know the exact time with the command to watch, suggesting that vigilant observation of the heavens will ultimately clarify what is unknown.

> ***Watch therefore,** for ye know neither the day nor the hour wherein the Son of man cometh. (Matthew 25:13)*

Only in modern times has “knowledge increased” (Daniel 12:4) enough for the average person to accurately track the positions of celestial bodies. Stellarium, the most popular free software for this purpose, has made it easier than ever to “look up” and observe the lights in the firmament, enabling users to identify potential signs, interpret prophecies, and track time. Understanding the symbols in Revelation with this approach represents a broad field of biblical research that has been a growing occupational interest over the past decade.

### Constellations

In biblical studies, constellations primarily serve as symbols that align with those described in Scripture. Both ancient and modern constellations across the sky may become relevant, as not only the classical “moving stars” of the ecliptic but also various cometary “clouds” may act as “messengers,” whether visible to the naked eye or not.

#### Summary of Modifications

* **Monoceros** – Changed to reflect the biblical meaning of the "unicorn" as a one-horned rhinoceros. [#59] Constellation lines adjusted accordingly.
* (**Virgo** – Suitable for use in the context of the harlot of Revelation 17.)
* **Andromeda** – Modified for modesty.
* **Orion** – Two constellation lines have been added reflecting the centrality of Alnitak in the clock, connecting it to Rigel and Bellatrix.
* **Horologium** – Overlaid a cross to emphasize the clock's role in pointing to the crucifixion of Jesus (who died at the ninth hour in Hebrew terms, or aboout 3:00pm as the clock's constellation lines indicate).
* **The Cross** – An added constellation depicting Jesus on the cross at the Sagittarius crossing of the galactic equator and the ecliptic, where the full moon stood at the time of His crucifixion. [#60] In single constellation mode, select by finding "The Cross".
* (**Eridanus** – Colored red to reflect the blood of Christ that flows from the cross through time.)

##### The Unicorn

The depiction of most constellations in the *modern* sky culture is generally suitable for biblical study, but some adjustments are necessary. For instance, the “unicorn,” is mentioned several times in the Bible, but not in reference to the mythical horned horse. Studies suggest that the referenced animal was likely the rhinoceros.[#59] While some scholars propose an ancient type of wild ox, the term “unicorn” (meaning “one horn”) does not support this view, because oxen universally have two horns. Accordingly, the White Cloud Farm sky cultures depict the constellation of Monoceros as a one-horned rhinoceros.

<p><img src="illustrations/desc-monoceros.jpg" align="center"/></p>

##### Virgo and Andromeda

In a biblical setting, a virgin would certainly be more modest than the modern artwork portrays, and has been modified to reflect that in the Standard Edition of the White Cloud Farm sky cultures. Nevertheless, the original is indeed appropriate for the harlot of Revelation 17:3-4 (a role Virgo may represent in certain contexts, as indicated by the golden cup “in her hand”). She is depicted accordingly in the Babylon Edition.

<p><img src="illustrations/desc-virgo+cup.jpg" align="center"/></p>

Similarly, Andromeda, portrayed as a beautiful woman chained to a rock, reflects the biblical imagery of the church who is bound with sacrificial commitment to her Rock, Jesus (Matthew 21:44, Ephesians 5:25-27).[#61] Therefore, her depiction should avoid any shameful representation, as is typical for the Greek myth.

##### The Cross

For over a century, certain elements of the symbolism in the Mazzaroth at the intersection of the galactic equator and the ecliptic in Sagittarius have been recognized as resembling the oldest explicit prophecy in the Bible: the promise of the Redeemer, whose feet would be “bruised” by the serpent.

> *And the LORD God said unto the serpent, … I will put enmity between thee and the woman, and between thy seed and her seed; it shall bruise thy head, and **thou shalt bruise his heel.** (Genesis 3:14-15)*

This prophecy was fulfilled at the cross. In the heavens, the scorpion’s sting symbolizes those among Jesus’ own people who turned against Him. As early as 1893, E.W. Bullinger noted that,

> The real wounding in the heel was received at the Cross. It was there the scorpion struck the woman’s seed. He died, but was raised again from the dead “to destroy the works of the devil.”[#62]

In this context, Sagittarius may represent the Roman soldier who pierced Jesus’ side to confirm His death, while Ophiuchus, the serpent-bearer positioned above the scorpion as though riding it, symbolizes one who hosts the serpent (Satan) himself. This “assembly of the wicked,” along with the wolf, Lupus, all surround this location in heaven, strikingly matching the messianic psalm:[#63]

> *For dogs have compassed me: the assembly of the wicked have inclosed me: they pierced my hands and my feet. (Psalms 22:16)*

At the precise hour of Jesus’ crucifixion, according to White Cloud Farm studies of the biblical calendar and prophecy,[#64] the 100.0% full moon stood precisely at this galactic crossing, marking this position for the Lord’s cross in the heavens.[#60] Therefore, an important constellation is included, simply called “The Cross.”

<p><img src="illustrations/desc-cross-moon.jpg" align="center"/></p>

This additional constellation is not assigned a specific area, as it is associated with the galactic equator itself. (To select this constellation in “Select single constellation” mode, use the Find feature with “The Cross” as the search term.)

##### Orion and the Horologium

The White Cloud Farm studies began publicly in January of 2010 with the realization that Orion served as a celestial clock, recognized by its distinctive hourglass shape.[#65] A decade later, when the largest comet ever discovered (C/2014 UN271 Bernardinelli-Bernstein) was identified as a comet shortly after entering Horologium, their attention turned to that constellation. Its stellar hour hand points to three o’clock, the hour of Christ’s death on the cross.[#66] The 3rd, 6th, and 9th hours of the day (approximately 9:00 AM, 12:00 PM, and 3:00 PM), along with morning and evening (6:00 AM/PM), are all linked to the story of Christ’s crucifixion (Mark 15:1, 25, 33-34, 42). These hours on a 12-hour clock form a cross, as depicted in the Horologium.[#67]

This suggests that Horologium points to Jesus’ crucifixion, while Orion symbolizes His triumphant resurrection and victory over the cross. E.W. Bullinger recognized the latter from the name of the left belt star.

> The name of the fourth star, δ (one of the three in the belt), carries us back to the old, old story, that this glorious One was once humbled; that His heel was once bruised. Its name is Al Nitak, **the wounded One.**[#68]

Orion holds a dead lion in his arm, signifying the defeat of the roaring lion that seeks to devour (1 Peter 5:8). Orion embodies the singularly worthy Lion of the tribe of Judah (Revelation 5:5). In the Clock Edition of the White Cloud Farm sky cultures, Orion is shown as an hourglass, with the Alnitak-centered clockface superimposed.

<p><img src="illustrations/desc-clocks.jpg" align="center"/></p>

##### Eridanus

The river separating the two heavenly clocks depicts Phaeton of Greek mythology, dead and buried within its midst. In a biblical context, this symbolizes the burial of Jesus. His death was the spiritual baptism He would endure (Luke 12:50). Above this point in the river, a dove aims downward, recalling the Spirit that descended like a dove upon Jesus during His literal baptism.

<p><img src="illustrations/desc-dove-baptism.jpg" align="center"/></p>

> *And straightway coming up out of the water, he saw the heavens opened, and the Spirit like a dove descending upon him: (Mark 1:10)*

Thus, the river represents both the cleansing water of baptism and the covenant of blood that Jesus ratified for the world, flowing between the two representations of the Faithful and True Witness (in Horologium and Orion, respectively). For this reason, in the Clock Edition, the constellation is depicted as a river representing the flow of time, while other editions feature it as a river of His blood symbolically flowing from His sacrifice at the cross.

##### Cometary Shapes

While not “constellations”, the paths of comets may also illustrate shapes relevant to biblical prophecy. One striking example is formed by the well-known comets C/2017 K2 (PanSTARRS)—once the largest known comet until C/2014 UN271 (Bernardinelli-Bernstein) was classified as one—and C/2022 E3 (ZTF) simultaneously framed this region between Horologium and Orion with their ephemerides, forming a shape resembling a great fish.[#69]

<p><img src="illustrations/desc-sign-of-son-of-man.jpg" width="660" align="center"/></p>

> *For as Jonas was three days and three nights in the whale's belly; so shall the Son of man be three days and three nights in the heart of the earth. (Matthew 12:40)*

The dove within the “whale’s belly” evokes Jonah, whose Hebrew name means “dove,” while the three days of Jesus’ death, burial, and resurrection are represented in the Horologium, Eridanus, and Orion, respectively, as described above.[#70]

## References

 - [#1]: Kunitzsch, P.; Smart T. (2006). "A Dictionary of Modern star Names: A Short Guide to 254 Star Names and Their Derivations" (2nd rev. ed.). Cambridge, MA: Sky Pub. ISBN 978-1-931559-44-7.
 - [#2]: Allen, R. H. (1963). "Star Names: Their Lore and Meaning" (rep. ed.). New York, NY: Dover Publications Inc. ISBN 0-486-21079-0.
 - [#3]: [2000, A&AS, 143, 9, "The SIMBAD astronomical database", Wenger et al.](http://adsabs.harvard.edu/abs/2000A%26AS..143....9W)
 - [#4]: [Final Results of NameExoWorlds Public Vote Released](http://www.iau.org/news/pressreleases/detail/iau1514/)
 - [#5]: [STARS by Jim Kaler, Prof. Emeritus of Astronomy, University of Illinois](http://stars.astro.illinois.edu/sow/sowlist.html)
 - [#6]: [IAU Catalog of Star Names (IAU-CSN)](http://www.pas.rochester.edu/~emamajek/WGSN/IAU-CSN.txt)
 - [#7]: [Covington, Michael (2002). "Celestial Objects for Modern Telescopes: Practical Amateur Astronomy". Cambridge University Press.](https://books.google.com/books?id=ql7wLq1fP5QC&pg=PA209)
 - [#8]: ["61 Cyg (Piazzi's Flying Star)". Science&Space News. Retrieved June 1, 2015.](http://news.sky-map.org/starview?object_type=1&object_id=2282&object_name=HD+201091&locale=EN)
 - [#9]: [Kruger 60](https://en.wikipedia.org/wiki/Kruger_60)
 - [#10]: [List of Named Stars in Alphabetical Order](https://web.archive.org/web/20220701073320/http://www.astro.wisc.edu/~dolan/constellations/starname_list.html)
 - [#11]: [Jack W. Rhoads (1971). "Reduced Star Catalog Containing 537 Named Stars", Jet Propulsion Laboratory, California Institute of Technology; November 15, 1971](https://ntrs.nasa.gov/citations/19720005197)
 - [#12]: [IAU Naming Stars](https://www.iau.org/public/themes/naming_stars/)
 - [#13]: [Bright Star Catalogue, 5th Revised Ed. (Hoffleit+, 1991)](http://vizier.u-strasbg.fr/viz-bin/VizieR?-source=V/50)
 - [#14]: Piazzi, G, ed. (1814). "Praecipuarum Stellarum Inerrantium Positiones Mediae Ineunte Saeculo XIX: ex Observationibus Habitis in Specula Panormitana ab anno 1792 ad annum 1813". Palermo. p. 21.
 - [#15]: Kunitzsch, P. (1959). "Arabische Sternnamen in Europa". Wiesbaden: Otto Harrassowitz. p. 155.
 - [#16]: Laffitte, R. (2005). "Héritages arabes: Des noms arabes pour les étoiles" (2éme revue et corrigée ed.). Paris: Librairie Orientaliste Paul Geunthner / Les Cahiers de l'Orient. p. 229.
 - [#17]: Burritt, E. H. (1835). "Atlas, Designed to Illustrate the Geography of the Heavens" (new ed.). New York: F. J. Huntington. plate III.
 - [#18]: Burnham, Robert Jr. (1978, 1979). "Burnham's Celestial Handbook: An Observer's Guide to the Universe Beyond the Solar System", Vol. 1, 2, 3. NY: Dover Publications. ISBN 978-0486235677, 978-0486235684, 978-0486236735
 - [#19]: [Iota Ursae Majoris](https://en.wikipedia.org/wiki/Iota_Ursae_Majoris)
 - [#20]: [Falkner, David E. (2011). "The Mythology of the Night Sky: An Amateur Astronomer's Guide to the Ancient Greek and Roman Legends", Patrick Moore's Practical Astronomy, Springer. ISBN 1-4614-0136-4](https://books.google.com/books?id=tyj8UUE968wC)
 - [#21]: Peters, C. A. F. (1853). "On the Parallax of Argelander's Star". Monthly Notices of the Royal Astronomical Society, Vol. 14, p.49. DOI: 10.1093/mnras/14.2.49
 - [#22]: Maddocks, Hugh C. (1991). "Deep-Sky Name Index 2000.0". Foxon-Maddocks Associates. ISBN 0-9628305-0-X.
 - [#23]: Josef Klepesta, Antonin Rükl (1977). "Constellations: A concise guide in colour". ISBN 0600008932.
 - [#24]: Oswald Thomas (1945). "Atlas der Sternbilder". Das Bergland-Buch, Salzburg.
 - [#25]: Fred Schaaf (2019). "An Assortment of Asterisms". Sky & Telescope, p.45 (Nov 2019)
 - [#26]: Gary Seronik (2017). "Binocular Highlights Revised & Expanded: 109 Celestial Sights for Binocular Users". F W Publications Inc. ISBN 9781940038445
 - [#27]: Tony Flanders (2019). "Constellation Close-up: Centaurus and Crux". Sky & Telescope, pp.22-27 (Apr 2019).
 - [#28]: Sue French (2019). "Deep-Sky Wonders: Heavenly Hero". Sky & Telescope, pp.54-56 (Jul 2019).
 - [#29]: [Software Bisque: A Complete List of Asterisms](https://www.bisque.com/tom/asterisms/list.asp)
 - [#30]: [University of Northern Iowa, EARTHSCI 1100 - Astronomy, Asterisms.](https://sites.uni.edu/morgans/astro/asterisms.html)
 - [#31]: [Horvatin - Obsolete Constellations, Department of Physics and Astronomy, Michigan State University.](https://web.pa.msu.edu/people/horvatin/Astronomy_Facts/obsolete_pages/triangulum_minor.htm)
 - [#32]: [Donald H. Menzel (1964). A Field Guide to the Stars and Planets by Donald H. Menzel, Collins books - St. James's Place, London. ISBN: 0395934311, ISBN13: 9780395934319](http://www.arvindguptatoys.com/arvindgupta/menzel-fieldguide.pdf)
 - [#33]: [James B. (Jim) Kaler. Professor Emeritus of Astronomy, University of Illinois.](http://stars.astro.illinois.edu/sow/6tri.html)
 - [#34]: [Astronomy Club of Tulsa - Observer, December 2008.](http://www.astrotulsa.com/cms_files/200812.pdf)
 - [#35]: [Baylor University, School of Engineering and Computer Science, Astronomy observing log.](http://cs.baylor.edu/~hamerly/personal/astro/log.html)
 - [#36]: [IAU100 NameExoWorlds](http://nameexoworlds.iau.org/)
 - [#37]: [The Washington Double Star Catalog (Mason+ 2001-2020)](https://vizier.u-strasbg.fr/viz-bin/VizieR?-source=B/wds)
 - [#38]: [Patrick Moore, Paul Doherty, H. J. P. Arnold, The Photographic Atlas of the Stars, CRC Press LLC, 1999. ISBN 0750306548 (EXCLUDED (too many typos))](https://books.google.com/books?id=YjcvJUfnWBAC&pg=PA97#v=onepage&q&f=false)
 - [#39]: [Guy Consolmagno, Dan M. Davis, Turn Left at Orion, Cambridge University Press, 2019. ISBN 9781108558464](https://doi.org/10.1017/9781108558464)
 - [#40]: Delporte, Eugene (1930). "Delimitation scientifique des constellations (tables et cartes)". Cambridge.
 - [#41]: facsimile: Uranometria von Johannes Bayer, Kunstschätzeverlag, Gerchsheim, 2010
 - [#42]: facsimile: Die große Flamsteed Edition - Himmelskartographie nach John Flamsteed von 1776 bis 1805, Albireo Verlag, Köln, 2017
 - [#43]: Latußeck, Arndt and Hoffmann, Susanne M: "Ein nützliches Unternehmen", Albireo Verlag, Köln, 2017
 - [#44]: [Constellation english names. IAU Constellations Page](https://www.iau.org/public/themes/constellations/)
 - [#45]: [IAU Working Group Star Names. WGSN](https://www.iau.org/science/scientific_bodies/working_groups/280/)
 - [#46]: Grasshoff, Gerd: The History of Ptolemy's Star Catalogue, Springer, New York, 1990
 - [#47]: Hoffmann, Susanne M.: Hipparchs Himmelsglobus, Springer, Wiesbaden / New York, 2017
 - [#48]: [Constellation. Article on Wikipedia](http://en.wikipedia.org/wiki/Constellation)
 - [#49]: [Star Catalogue. Article on Wikipedia](http://en.wikipedia.org/wiki/Star_catalogue)
 - [#50]: [Constellation image library of the U.S. Naval Observatory and the Space Telescope Science Institute. Johannes Hevelius Engravings.](http://hubblesource.stsci.edu/sources/illustrations/constellations/)
 - [#51]: Santiago Paolantonio, Beatriz García (2019). "Uranometría Argentina and the constellation boundaries". Under One Sky: The IAU Centenary Symposium. Cambridge. p. 505.
 - [#52]: Meade Instruction Manual 7" LX200 Maksutov-Cassegrain Telescope; 8", 10", and 12" LX200 Schmidt-Cassegrain Telescopes
 - [#53]: [Mike Wall (2013). "Strange 'Methuselah' Star Looks Older Than the Universe". Space.com](https://www.space.com/20112-oldest-known-star-universe.html)
 - [#54]: [Space Telescope Science Institute (STScI). "Hubble finds 'birth certificate' of oldest known star." ScienceDaily. ScienceDaily, 7 March 2013](www.sciencedaily.com/releases/2013/03/130307145103.htm)
 - [#55]: [Atlas Coeli Skalnaté Pleso 1950.0](https://en.wikipedia.org/wiki/Skalnate_Pleso_Atlas_of_the_Heavens)
 - [#56]: [Karlseiche](https://de.wikipedia.org/wiki/Karlseiche)
 - [#57]: [Mural Quadrant](https://de.wikipedia.org/wiki/Mauerquadrant_(Sternbild))
 - [#58]: WAA/Alexander Pikhard. Own creation, 2001. https://www.waa.at/bericht/2001/06_sofiexp/20010612/bb20010612.html. 
 - [#59]: Hoffman, Nathan. Creation Today: [Why Does The Bible Mention Unicorns?](https://creationtoday.org/why-does-the-bible-mention-unicorns/)
 - [#60]: Dickinson, Robert (2022). White Cloud Farm: [The Heart of Time](https://whitecloudfarm.org/article-series/the-bridegroom-cometh/the-heart-of-time)
 - [#61]: Dickinson, Robert (2021). White Cloud Farm: [The Maiden and the Millstone](https://whitecloudfarm.org/article-series/the-bridegroom-cometh/the-maiden-and-the-millstone)
 - [#62]: Bullinger, Ethelbert W. (1893). "The Witness of the Stars". St. Paul's Churchyard, E.C., p. 56
 - [#63]: Dickinson, Ray (2022). White Cloud Farm: [Looking Up to All Truth](https://whitecloudfarm.org/article-series/the-bridegroom-cometh/the-covenant-delivered/looking-up-to-all-truth)
 - [#64]: Scotram, John (2010). Last Countdown: [Full Moon at Gethsemane – Part 1](https://lastcountdown.whitecloudfarm.org/shadows-of-the-future/gethsemane/shadows-gethsemane-1)
 - [#65]: Scotram, John (2010). Last Countdown: [The Clock of God in Orion](https://lastcountdown.whitecloudfarm.org/the-clock-of-god/the-orion-message)
 - [#66]: Dickinson, Robert (2021). White Cloud Farm: [The Rod of Iron](https://whitecloudfarm.org/article-series/the-bridegroom-cometh/the-rod-of-iron)
 - [#67]: Dickinson, Ray (2024). White Cloud Farm: [If I Be Lifted Up](https://web3.whitecloudfarm.org/video/?v=100203489) (Video.)
 - [#68]: Bullinger, Ethelbert W. (1893). "The Witness of the Stars". St. Paul's Churchyard, E.C., p. 127
 - [#69]: Dickinson, Robert (2023). White Cloud Farm: [The Sign Has Appeared](https://whitecloudfarm.org/article-series/go-ye-out/the-divine-monogram/the-sign-has-appeared)
 - [#70]: Dickinson, Ray (2024). White Cloud Farm: [A Time to Prophesy](https://web3.whitecloudfarm.org/video/?v=100203466) (Video.)

## Authors

Since 2010, the White Cloud Farm has publicly shared its studies of the heavens, beginning with the Clock of God in Orion. Building on this foundation, since 2017, we have explored how the Mazzaroth—the Hebrew term for the Zodiac—illustrates certain prophecies in Revelation. In 2020, Comet C/2020 F3 (NEOWISE), a naked-eye comet, drew our attention as it passed through our “Alma Mater,” Orion. Over time, a progressively clearer picture has emerged of how earthly events are highlighted, linking them to Revelation’s prophecies through the symbols in the constellations, marked by the sun, moon, relevant planets, and the cometary clouds of heaven.

For any questions, or to suggest changes, please contact us through our websites.

Modified by the Publishing Team at the  
**White Cloud Farm,** Paraguay | https://whitecloudfarm.org  
Babylon Edition  
Version 1.0, September 2025

<p><img src="illustrations/desc-temple.jpg" align="center"/></p>

WhiteCloudFarm.org (Nov. 2016 – Present)  
LastCountdown.org (Jan. 2010 – Oct. 2016)  

## License

Text and data: CC BY-SA 4.0

Illustrations: Free Art License
